(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    110396,       3229]
NotebookOptionsPosition[    102660,       3089]
NotebookOutlinePosition[    103060,       3105]
CellTagsIndexPosition[    103017,       3102]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", 
   RowBox[{"x", "+", 
    RowBox[{
     RowBox[{
      RowBox[{"h", "^", "\[Alpha]"}], "/", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"r", " ", "x"}], "-", 
       RowBox[{"x", " ", "y"}]}], ")"}]}], "-", 
    RowBox[{"k1", 
     RowBox[{"(", 
      RowBox[{"x", "-", "xstar"}], ")"}]}], "-", 
    RowBox[{"k2", 
     RowBox[{"(", 
      RowBox[{"y", "-", "ystar"}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f2", "=", 
    RowBox[{"y", "+", 
     RowBox[{
      RowBox[{
       RowBox[{"h", "^", "\[Alpha]"}], "/", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], 
      RowBox[{"(", 
       RowBox[{"\[Sigma]", "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "r"}], ")"}], " ", "y"}], "-", 
        RowBox[{"d", " ", "x"}], "+", 
        RowBox[{"x", " ", "y"}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"J", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"f1", ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{"f1", ",", "y"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"f2", ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{"f2", ",", "y"}], "]"}]}], "}"}]}], "}"}], "//", 
   RowBox[{"MatrixForm", " ", 
    TemplateBox[{
      TemplateBox[{
        GraphicsBox[{
          InsetBox[
          "", {-0.8452694583248785, -0.1422890625000015}, {Left, Baseline}, 
           Alignment -> {Left, Top}], 
          StyleBox[
           InsetBox[
           "", {-1.0121165001719197`, 0.34304427083333167`}, {Left, Top}, {
            1.6053391053391053`, Automatic}, Alignment -> {Left, Top}], 
           FontColor -> Hue[0., 1, 0.4833333333333333], FontOpacity -> 1]}, 
         AspectRatio -> 0.06493506493506493, 
         DefaultBaseStyle -> {"CanvasGraphics"}, 
         ImagePadding -> {{0., 0.}, {0., 0.}}, ImageSize -> {231, 15}, 
         PlotRange -> {{-1.0416666666666667`, 1.0416666666666667`}, {-1.04, 
          1.04}}, PlotRangePadding -> Automatic]}, "CanvasFrame"], 
      PaneBox[
       RowBox[{"(*", 
         RowBox[{"compute", " ", "the", " ", "jacobian", " ", "matrix"}], " ",
          "*)"}], ImageSize -> {231, 15}, BaselinePosition -> Baseline, 
       ImageSizeAction -> "ShrinkToFit", BoxID -> "ForCanvasToggle"]},
     "CanvasOverlay"]}]}]}]}], "Input",
 CellChangeTimes->{{3.955627502649973*^9, 3.955627532324524*^9}, {
  3.9556276664227295`*^9, 3.955627722101572*^9}, {3.974005663647314*^9, 
  3.9740057177971287`*^9}},ExpressionUUID->"c7e555be-d259-6b4b-931f-\
4cc5b63ec8ae"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"1", "-", "k1", "+", 
       FractionBox[
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", "y"}], ")"}]}], 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}], 
      RowBox[{
       RowBox[{"-", "k2"}], "-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", "x"}], 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}]},
     {
      FractionBox[
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "d"}], "+", "y"}], ")"}]}], 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]], 
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "r"]}], "+", "x"}], ")"}]}], 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.973735167129938*^9, 3.9737355694246006`*^9, 
  3.9737376698417397`*^9, 3.9739186180652046`*^9, 3.9739196422543793`*^9, 
  3.97400502093322*^9},
 CellLabel->
  "Out[3]//MatrixForm=",ExpressionUUID->"5ea7f43e-e4e2-0947-9ada-\
0b59de806228"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", " ", "=", " ", 
  RowBox[{
   RowBox[{
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         RowBox[{"1", "-", "k1", "+", 
          FractionBox[
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{"r", "-", "y"}], ")"}]}], 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}], 
         RowBox[{
          RowBox[{"-", "k2"}], "-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", "x"}], 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}]},
        {
         FractionBox[
          RowBox[{
           SuperscriptBox["h", "\[Alpha]"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "d"}], "+", "y"}], ")"}]}], 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]], 
         RowBox[{"1", "+", 
          FractionBox[
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               FractionBox["1", "r"]}], "+", "x"}], ")"}]}], 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "->", 
       FractionBox[
        RowBox[{"1", "-", "\[Sigma]"}], 
        RowBox[{"r", "-", "d"}]]}], ",", 
      RowBox[{"y", "->", "r"}]}], "}"}]}], "//", "MatrixForm"}]}]], "Input",
 CellChangeTimes->{{3.973735189416445*^9, 3.973735248684019*^9}, {
  3.9737355722682247`*^9, 3.9737355887946873`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"d596aa5a-cd89-304e-962b-1a9a3e18f9c9"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"1", "-", "k1"}], 
      RowBox[{
       RowBox[{"-", "k2"}], "-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Sigma]"}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]},
     {
      FractionBox[
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "d"}], "+", "r"}], ")"}]}], 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]], 
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "r"]}], "+", 
           FractionBox[
            RowBox[{"1", "-", "\[Sigma]"}], 
            RowBox[{
             RowBox[{"-", "d"}], "+", "r"}]]}], ")"}]}], 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.973735201863394*^9, 3.973735249789913*^9, {3.973735579720867*^9, 
   3.9737355893149986`*^9}, 3.973737675119358*^9, 3.9739186181836205`*^9, 
   3.97391964239979*^9, 3.974005023219578*^9},
 CellLabel->
  "Out[4]//MatrixForm=",ExpressionUUID->"9a9dbecb-e054-f744-8b98-\
7d5aa39740a4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"1", "-", "k1"}], 
        RowBox[{
         RowBox[{"-", "k2"}], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["h", "\[Alpha]"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Sigma]"}], ")"}]}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]},
       {
        FractionBox[
         RowBox[{
          SuperscriptBox["h", "\[Alpha]"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "d"}], "+", "r"}], ")"}]}], 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]], 
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["h", "\[Alpha]"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              FractionBox["1", "r"]}], "+", 
             FractionBox[
              RowBox[{"1", "-", "\[Sigma]"}], 
              RowBox[{
               RowBox[{"-", "d"}], "+", "r"}]]}], ")"}]}], 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{3.974005032288643*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"92a82ba8-e563-2245-bd3c-745cb4094336"],

Cell[BoxData[
 RowBox[{"1", "-", "k1", "-", 
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{"k1", " ", "x"}], "+", 
  SuperscriptBox["x", "2"], "-", 
  FractionBox[
   RowBox[{"d", " ", 
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]], " ", "r"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{"d", " ", 
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]], " ", "\[Sigma]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]], " ", "r", " ", "\[Sigma]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "-", 
  FractionBox[
   RowBox[{"d", " ", 
    SuperscriptBox["h", "\[Alpha]"], " ", "k2"}], 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[Alpha]"}], "]"}]], "-", 
  FractionBox[
   SuperscriptBox["h", "\[Alpha]"], 
   RowBox[{"r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "k1"}], 
   RowBox[{"r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", "r"}], 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[Alpha]"}], "]"}]], "+", 
  FractionBox[
   SuperscriptBox["h", "\[Alpha]"], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "k1"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "x"}], 
   RowBox[{"r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "x"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", "\[Sigma]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", "\[Sigma]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{3.974005032370268*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"9f97c47f-e95b-f044-9c14-6667bf0f2bf8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{"1", "-", "k1", "-", 
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"k1", " ", "x"}], "+", 
    SuperscriptBox["x", "2"], "-", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]], " ", "r"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "+", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]], " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]], " ", "r", " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "-", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["h", "\[Alpha]"], " ", "k2"}], 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]], "-", 
    FractionBox[
     SuperscriptBox["h", "\[Alpha]"], 
     RowBox[{"r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "k1"}], 
     RowBox[{"r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", "r"}], 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]], "+", 
    FractionBox[
     SuperscriptBox["h", "\[Alpha]"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "k1"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "x"}], 
     RowBox[{"r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "x"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.973735636272665*^9, 3.973735661603035*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"3e120c17-c08e-df42-bc97-448fed5ec861"],

Cell[BoxData[
 RowBox[{"1", "-", "k1", "+", 
  SuperscriptBox["x", "2"], "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "k1", "+", 
     FractionBox[
      SuperscriptBox["h", "\[Alpha]"], 
      RowBox[{"r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
     FractionBox[
      SuperscriptBox["h", "\[Alpha]"], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], ")"}]}], "-", 
  FractionBox[
   RowBox[{"d", " ", 
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]], " ", "r"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{"d", " ", 
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]], " ", "\[Sigma]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]], " ", "r", " ", "\[Sigma]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "-", 
  FractionBox[
   RowBox[{"d", " ", 
    SuperscriptBox["h", "\[Alpha]"], " ", "k2"}], 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[Alpha]"}], "]"}]], "-", 
  FractionBox[
   SuperscriptBox["h", "\[Alpha]"], 
   RowBox[{"r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "k1"}], 
   RowBox[{"r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", "r"}], 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[Alpha]"}], "]"}]], "+", 
  FractionBox[
   SuperscriptBox["h", "\[Alpha]"], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "k1"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", "\[Sigma]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{{3.973735658142851*^9, 3.9737356622612247`*^9}, 
   3.9737376865371456`*^9, 3.9739186182566547`*^9, 3.973919642464819*^9, 
   3.9740050474132137`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"95f24ab6-8f4b-c442-831a-062530d99ae0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p3", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "k1", "+", 
    FractionBox[
     SuperscriptBox["h", "\[Alpha]"], 
     RowBox[{"r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
    FractionBox[
     SuperscriptBox["h", "\[Alpha]"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.9737356644559097`*^9, {3.973736609937956*^9, 3.9737366412974567`*^9}, {
   3.973736881140772*^9, 3.9737368826842804`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"6c05c2e6-8556-d24b-a83f-2f908586e7bd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", "k1", "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{"d", "-", 
      RowBox[{"r", " ", "\[Sigma]"}]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{3.97373664402289*^9, 3.973736885437807*^9, 
  3.973737703501034*^9, 3.973918618435423*^9, 3.973919642635889*^9, 
  3.9740050521415844`*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"0a6da35c-a0bb-f245-9dba-d557f7134f70"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p2", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"1", "-", "k1", "-", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]], " ", "r"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "+", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]], " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]], " ", "r", " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]], "-", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["h", "\[Alpha]"], " ", "k2"}], 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]], "-", 
    FractionBox[
     SuperscriptBox["h", "\[Alpha]"], 
     RowBox[{"r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "k1"}], 
     RowBox[{"r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", "r"}], 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]], "+", 
    FractionBox[
     SuperscriptBox["h", "\[Alpha]"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "k1"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9737366562299023`*^9, 3.973736658124996*^9}, {
  3.973736692334421*^9, 3.973736720453142*^9}, {3.9737369001500397`*^9, 
  3.9737369070478344`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"02fb311f-5420-3446-92ed-c91809b5b90c"],

Cell[BoxData[
 RowBox[{"1", "-", "k1", "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["h", "\[Alpha]"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["d", "2"], " ", "k2", " ", "r"}], "+", 
          RowBox[{"k2", " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "k1", "+", 
             RowBox[{"2", " ", "k2", " ", 
              SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "k1"}], ")"}], " ", "r", " ", 
           "\[Sigma]"}]}], ")"}], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]]}]], "Output",
 CellChangeTimes->{3.973736723216818*^9, 3.973736909615038*^9, 
  3.9737377089095745`*^9, 3.9739186193995705`*^9, 3.973919643746578*^9, 
  3.974005056001175*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"47a9cf8c-c8d5-7949-8a88-100779dd8331"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(", "\[NoBreak]", GridBox[{
    {
     RowBox[{"1", "-", "k1"}], 
     RowBox[{
      RowBox[{"-", "k2"}], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Sigma]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]},
    {
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}]}], 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]], 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "r"]}], "+", 
          FractionBox[
           RowBox[{"1", "-", "\[Sigma]"}], 
           RowBox[{
            RowBox[{"-", "d"}], "+", "r"}]]}], ")"}]}], 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}]}
   },
   GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}], "\[NoBreak]", ")"}]], "Input",
 CellChangeTimes->{3.973736952665516*^9},
 CellLabel->"In[11]:=",ExpressionUUID->"0d4bcbf9-f0b8-e249-9db7-6f7088d0d734"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "-", "k1"}], ",", 
     RowBox[{
      RowBox[{"-", "k2"}], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Sigma]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}]}], 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]], ",", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "r"]}], "+", 
          FractionBox[
           RowBox[{"1", "-", "\[Sigma]"}], 
           RowBox[{
            RowBox[{"-", "d"}], "+", "r"}]]}], ")"}]}], 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9737367868873234`*^9, 3.9737369134148407`*^9, 
  3.973736953841385*^9, 3.973737754986044*^9, 3.9739186194542503`*^9, 
  3.973919643798231*^9, 3.974005063983101*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"9a79bf59-581f-ab4d-9992-c7fd1db2ac36"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "-", "k1"}], ",", 
      RowBox[{
       RowBox[{"-", "k2"}], "-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Sigma]"}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "d"}], "+", "r"}], ")"}]}], 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]], ",", 
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "r"]}], "+", 
           FractionBox[
            RowBox[{"1", "-", "\[Sigma]"}], 
            RowBox[{
             RowBox[{"-", "d"}], "+", "r"}]]}], ")"}]}], 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}]}], "}"}]}], "}"}], 
  "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[12]:=",ExpressionUUID->"f054aa81-0146-0246-b3a2-98aa553e25f0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "d"}], " ", 
       SuperscriptBox["h", "\[Alpha]"]}], "+", 
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", "\[Sigma]"}], "+", 
      RowBox[{"2", " ", "d", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
      RowBox[{"d", " ", "k1", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
      RowBox[{"k1", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
      RowBox[{"\[Sqrt]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"8", " ", "d", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "4"]}], "-", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", "r", " ", "\[Sigma]"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "2"], " ", "\[Sigma]"}], "-", 
         RowBox[{"8", " ", "d", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "3"], " ", "\[Sigma]"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "4"], " ", "\[Sigma]"}], "+", 
         RowBox[{
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["\[Sigma]", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", "r", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "3"], " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "3"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"12", " ", "d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "5"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", 
          SuperscriptBox["r", "2"], " ", "\[Sigma]", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", 
          SuperscriptBox["r", "3"], " ", "\[Sigma]", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["k1", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}], "-", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["k1", "2"], " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["k1", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]}], 
     ")"}]}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "d"}], " ", 
       SuperscriptBox["h", "\[Alpha]"]}], "+", 
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", "\[Sigma]"}], "+", 
      RowBox[{"2", " ", "d", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
      RowBox[{"d", " ", "k1", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
      RowBox[{"k1", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
      RowBox[{"\[Sqrt]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"8", " ", "d", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "4"]}], "-", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", "r", " ", "\[Sigma]"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "2"], " ", "\[Sigma]"}], "-", 
         RowBox[{"8", " ", "d", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "3"], " ", "\[Sigma]"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "4"], " ", "\[Sigma]"}], "+", 
         RowBox[{
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["\[Sigma]", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", "r", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "3"], " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "3"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"12", " ", "d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "5"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", 
          SuperscriptBox["r", "2"], " ", "\[Sigma]", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", 
          SuperscriptBox["r", "3"], " ", "\[Sigma]", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["k1", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}], "-", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["k1", "2"], " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["k1", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]}], 
     ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.973736963713827*^9, 3.9737377640512066`*^9, 
  3.973918619499012*^9, 3.9739196438392277`*^9, 3.9740050695785255`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"9eb79158-c5d7-254e-adeb-14a1a6454086"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lm1", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "d"}], " ", 
       SuperscriptBox["h", "\[Alpha]"]}], "+", 
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", "\[Sigma]"}], "+", 
      RowBox[{"2", " ", "d", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
      RowBox[{"d", " ", "k1", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
      RowBox[{"k1", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
      RowBox[{"\[Sqrt]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"8", " ", "d", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "4"]}], "-", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", "r", " ", "\[Sigma]"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "2"], " ", "\[Sigma]"}], "-", 
         RowBox[{"8", " ", "d", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "3"], " ", "\[Sigma]"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "4"], " ", "\[Sigma]"}], "+", 
         RowBox[{
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["\[Sigma]", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", "r", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "3"], " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "3"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"12", " ", "d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "5"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", 
          SuperscriptBox["r", "2"], " ", "\[Sigma]", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", 
          SuperscriptBox["r", "3"], " ", "\[Sigma]", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["k1", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}], "-", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["k1", "2"], " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["k1", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]}], 
     ")"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.973737006051628*^9, 3.973737013883833*^9}, {
  3.973737632437071*^9, 3.973737644854252*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"1c0c183a-6233-354f-b26f-0c74ed9192ca"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", 
      RowBox[{"(", 
       RowBox[{"d", "-", 
        RowBox[{"r", " ", "\[Sigma]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "k1"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", 
          RowBox[{"2", " ", "\[Alpha]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["d", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}]}], ")"}]}], 
           "-", 
           RowBox[{"2", " ", "d", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], "+", 
              "\[Sigma]"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], "+", 
              SuperscriptBox["\[Sigma]", "2"]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["h", "\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["d", "2"], " ", "k2", " ", "r"}], "+", 
              RowBox[{"2", " ", "k2", " ", 
               SuperscriptBox["r", "3"]}], "-", 
              RowBox[{"d", " ", 
               RowBox[{"(", 
                RowBox[{"k1", "+", 
                 RowBox[{"4", " ", "k2", " ", 
                  SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
              RowBox[{"k1", " ", "r", " ", "\[Sigma]"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["k1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.973737647926279*^9, 3.9737377754251804`*^9, 
  3.9739186291653366`*^9, 3.9739196537364483`*^9, 3.9740050847646713`*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"644bd247-9fbe-3648-819a-6e609e31bf08"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lm2", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "d"}], " ", 
       SuperscriptBox["h", "\[Alpha]"]}], "+", 
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", "\[Sigma]"}], "+", 
      RowBox[{"2", " ", "d", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
      RowBox[{"d", " ", "k1", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
      RowBox[{"k1", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
      RowBox[{"\[Sqrt]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"8", " ", "d", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "4"]}], "-", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", "r", " ", "\[Sigma]"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "2"], " ", "\[Sigma]"}], "-", 
         RowBox[{"8", " ", "d", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "3"], " ", "\[Sigma]"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "4"], " ", "\[Sigma]"}], "+", 
         RowBox[{
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["\[Sigma]", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", "r", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "3"], " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "3"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"12", " ", "d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k2", " ", 
          SuperscriptBox["r", "5"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", 
          SuperscriptBox["r", "2"], " ", "\[Sigma]", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "k1", " ", 
          SuperscriptBox["r", "3"], " ", "\[Sigma]", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["k1", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}], "-", 
         RowBox[{"2", " ", "d", " ", 
          SuperscriptBox["k1", "2"], " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["k1", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]}], 
     ")"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9737434356522236`*^9, 3.9737434651858673`*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"1ef5c451-09c4-544b-80ab-f9d3f4b28c20"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "d"}], "+", 
       RowBox[{"r", " ", "\[Sigma]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "k1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
    RowBox[{"\[Sqrt]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", 
         RowBox[{"2", " ", "\[Alpha]"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["d", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}]}], ")"}]}], 
          "-", 
          RowBox[{"2", " ", "d", " ", "r", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], "+", 
             "\[Sigma]"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], "+", 
             SuperscriptBox["\[Sigma]", "2"]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["h", "\[Alpha]"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["d", "2"], " ", "k2", " ", "r"}], "+", 
             RowBox[{"2", " ", "k2", " ", 
              SuperscriptBox["r", "3"]}], "-", 
             RowBox[{"d", " ", 
              RowBox[{"(", 
               RowBox[{"k1", "+", 
                RowBox[{"4", " ", "k2", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
             RowBox[{"k1", " ", "r", " ", "\[Sigma]"}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["k1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.973918632258356*^9, 3.9739196568060265`*^9, 
  3.9740050875381985`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"7b8838a8-2f1f-d749-b4ed-a2501038082c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lm3", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"lm1", "+", "lm2"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"lambda1", "+", "lambda2"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.9737435522786274`*^9, 3.9737436183716965`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"358ad470-bfb5-6e45-8823-41b42bfe82b0"],

Cell[BoxData[
 RowBox[{"2", "-", "k1", "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", 
      RowBox[{"r", " ", "\[Sigma]"}]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{
  3.9739186323894253`*^9, 3.9739196569220543`*^9, {3.9740051011517735`*^9, 
   3.9740051161404514`*^9}},
 CellLabel->"Out[18]=",ExpressionUUID->"f4bd2309-5988-3b40-beb0-2ba58f3289ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lm4", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"lm1", "*", "lm2"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"lambda1", "*", "lambda2"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.9737436214375095`*^9, 3.973743652333441*^9}, {
  3.9740051330127544`*^9, 3.9740051334857483`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"6dc6f156-63e0-7741-8782-71a02c218079"],

Cell[BoxData[
 RowBox[{"1", "-", "k1", "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["h", "\[Alpha]"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["d", "2"], " ", "k2", " ", "r"}], "+", 
          RowBox[{"k2", " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "k1", "+", 
             RowBox[{"2", " ", "k2", " ", 
              SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "k1"}], ")"}], " ", "r", " ", 
           "\[Sigma]"}]}], ")"}], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]]}]], "Output",
 CellChangeTimes->{3.973743669501875*^9, 3.973918632412422*^9, 
  3.973919656942108*^9, 3.974005105180172*^9, 3.974005139210621*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"180d2816-6761-3b4f-bb18-7be79335f73e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c1", "=", " ", 
  RowBox[{"lm4", " ", "==", "1", 
   RowBox[{"(*", 
    RowBox[{"lambda1lambda2", "=", "1"}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.9739185790317173`*^9, 3.9739185885521183`*^9}, {
  3.9739188645111027`*^9, 3.9739188773968925`*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"807fe882-5906-da4c-b26b-e4a12898751b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "-", "k1", "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["h", "\[Alpha]"]}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["d", "2"], " ", "k2", " ", "r"}], "+", 
           RowBox[{"k2", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"d", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "k1", "+", 
              RowBox[{"2", " ", "k2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "k1"}], ")"}], " ", "r", " ", 
            "\[Sigma]"}]}], ")"}], " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]]}], "\[Equal]", 
  "1"}]], "Output",
 CellChangeTimes->{3.973918594572092*^9, 3.973918632561638*^9, 
  3.973919657105425*^9, 3.9740051555360355`*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"f4aa79bd-36d5-0049-917b-c74e17faf28f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"c2", "=", 
   RowBox[{"c1", "/.", " ", 
    RowBox[{
     RowBox[{"Equal", "[", 
      RowBox[{"lhs_", ",", "rhs_"}], "]"}], ":>", 
     RowBox[{"Equal", "[", 
      RowBox[{
       RowBox[{"lhs", "-", "rhs"}], ",", "0"}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.973918759248312*^9, 3.97391877477792*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"6f84f3c2-d9dd-4c43-a2ac-b7c34e9240bc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"expandedEqn", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{"c2", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"collectedEqn", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{"expandedEqn", ",", 
    RowBox[{"{", 
     RowBox[{"k1", ",", "k2"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.9739188115620766`*^9, 3.973918814316309*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"b97819f6-6c6b-a548-ac8c-e5b9e3363b92"],

Cell[BoxData[
 RowBox[{
  RowBox[{"k2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["d", "2"], " ", 
        SuperscriptBox["h", "\[Alpha]"]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "+", 
     FractionBox[
      RowBox[{"2", " ", "d", " ", 
       SuperscriptBox["h", "\[Alpha]"], " ", "r"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       SuperscriptBox["r", "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], ")"}]}], "+", 
  RowBox[{"k1", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox[
      RowBox[{"d", " ", 
       SuperscriptBox["h", "\[Alpha]"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], ")"}]}], "+", 
  FractionBox[
   SuperscriptBox["h", 
    RowBox[{"2", " ", "\[Alpha]"}]], 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]], " ", "\[Sigma]"}], 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]], "-", 
  FractionBox[
   RowBox[{"d", " ", 
    SuperscriptBox["h", "\[Alpha]"]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{3.973919657127569*^9, 3.974005161544697*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"b02a2cd5-72a9-d64e-8044-291f4a59b21b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["d", "2"], " ", 
       SuperscriptBox["h", "\[Alpha]"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "+", 
    FractionBox[
     RowBox[{"2", " ", "d", " ", 
      SuperscriptBox["h", "\[Alpha]"], " ", "r"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", 
      SuperscriptBox["r", "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"coefficient", " ", "of", " ", "k2", " ", "for", " ", "L1"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.974005180352396*^9, 
  3.974005214913183*^9}},ExpressionUUID->"34f18b08-074b-0547-ae46-\
2e8b1d6f67b9"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["h", "\[Alpha]"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "d"}], "+", "r"}], ")"}]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "\[Alpha]"}], "]"}]]], "Output",
 CellChangeTimes->{3.974005193532194*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"bd515262-33bd-4c4e-ac08-7ed6a34502ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{"1", "+", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["h", "\[Alpha]"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"coefficient", " ", "of", " ", "k1", " ", "for", " ", "L1"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.9740052329368553`*^9, 3.9740052528829193`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"83f3eacc-ce47-1f40-9f12-6d7b79d5e339"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{"d", "-", 
      RowBox[{"r", " ", "\[Sigma]"}]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{{3.974005244228262*^9, 3.9740052549806805`*^9}},
 CellLabel->"Out[26]=",ExpressionUUID->"31bdbe05-0eee-9747-8b55-18f70a481ad9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    FractionBox[
     SuperscriptBox["h", 
      RowBox[{"2", " ", "\[Alpha]"}]], 
     SuperscriptBox[
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]], " ", "\[Sigma]"}], 
     SuperscriptBox[
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]], "-", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["h", "\[Alpha]"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"constant", " ", "term", " ", "for", " ", "L1"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.97400529020162*^9, 3.97400530850021*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"91f1f026-bc72-2246-acaf-3242b50757c3"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["h", "\[Alpha]"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["h", "\[Alpha]"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", 
         RowBox[{"r", " ", "\[Sigma]"}]}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]]], "Output",
 CellChangeTimes->{3.9740053109280014`*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"3544c471-f6d9-3c40-b9b0-ddae60e49b54"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"Assume", " ", "\[Lambda]1"}], "=", 
    RowBox[{
    "1.", " ", "Substituting", " ", "this", " ", "into", " ", "lm3"}]}], ",", 
   RowBox[{"we", " ", 
    RowBox[{"obtain", ":"}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.973919214493618*^9, 3.97391921947456*^9}, 
   3.973919391869774*^9},
 CellLabel->"In[23]:=",ExpressionUUID->"4a7d0483-5ebe-314b-aaf2-e5b32d5083a5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c3", "=", " ", 
  RowBox[{"lm3", "-", "1"}]}]], "Input",
 CellChangeTimes->{{3.973918979881035*^9, 3.9739190564261227`*^9}, {
   3.9739192283386936`*^9, 3.97391923795463*^9}, 3.973919412117401*^9},
 CellLabel->"In[28]:=",ExpressionUUID->"965652a7-2142-8e42-9ec7-89713432e5f2"],

Cell[BoxData[
 RowBox[{"1", "-", "k1", "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", 
      RowBox[{"r", " ", "\[Sigma]"}]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{3.973918987708271*^9, 3.9739196571611595`*^9, 
  3.974005390305111*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"b9dafd9e-eaba-484b-9bc2-f3653ad31b6b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"c3", " ", "give", " ", "formula", " ", "for", " ", "lambda2"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.9739194162381496`*^9, 3.973919420775011*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"6af14581-f8ab-7149-9e36-8709e73d01d2"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Now", ",", 
   RowBox[{
   "Since", " ", "we", " ", "have", " ", "two", " ", "expressions", " ", 
    "for", " ", "\[Lambda]2"}], ",", 
   RowBox[{"we", " ", "set", " ", "them", " ", "equal"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.9739192808135586`*^9, 3.973919307050535*^9}, {
   3.973919429302038*^9, 3.973919432824009*^9}, 3.973919491931919*^9},
 CellLabel->"In[26]:=",ExpressionUUID->"4465f9a9-0eb2-b541-911b-70fd9552ee9b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c4", " ", "=", " ", 
  RowBox[{"c3", "==", "lm4"}]}]], "Input",
 CellChangeTimes->{{3.9739190743144245`*^9, 3.973919105602913*^9}, {
  3.973919334081476*^9, 3.9739193348210964`*^9}, {3.9740053859573*^9, 
  3.9740053869206905`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"571a9710-5594-fe4a-adf7-4beb043937f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "-", "k1", "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "d"}], "+", 
       RowBox[{"r", " ", "\[Sigma]"}]}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "\[Equal]", 
  RowBox[{"1", "-", "k1", "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["h", "\[Alpha]"]}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["d", "2"], " ", "k2", " ", "r"}], "+", 
           RowBox[{"k2", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"d", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "k1", "+", 
              RowBox[{"2", " ", "k2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "k1"}], ")"}], " ", "r", " ", 
            "\[Sigma]"}]}], ")"}], " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]]}]}]], "Output",
 CellChangeTimes->{3.97391910860832*^9, 3.9739196571866226`*^9, 
  3.9740053927813263`*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"4cc08497-1f62-a14b-945d-c4098b0ee225"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"c5", " ", "=", " ", 
   RowBox[{"c4", "/.", " ", 
    RowBox[{
     RowBox[{"Equal", "[", 
      RowBox[{"lhs_", ",", "rhs_"}], "]"}], ":>", 
     RowBox[{"Equal", "[", 
      RowBox[{
       RowBox[{"lhs", "-", "rhs"}], ",", "0"}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9739195529894123`*^9, 3.9739195713666897`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"9ea03006-6989-4f49-902a-fa5068a0fe17"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"expandedEqn1", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{"c5", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"collectedEqn1", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{"expandedEqn1", ",", 
    RowBox[{"{", 
     RowBox[{"k1", ",", "k2"}], "}"}]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"find", " ", "L2"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.9739195756704826`*^9, 3.973919578392149*^9}, {
  3.9739196974775066`*^9, 3.9739197353033924`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"d0f78764-4bc3-434d-8aa8-f0de0d4457e4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"k2", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["d", "2"], " ", 
       SuperscriptBox["h", "\[Alpha]"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
     FractionBox[
      RowBox[{"2", " ", "d", " ", 
       SuperscriptBox["h", "\[Alpha]"], " ", "r"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       SuperscriptBox["r", "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], ")"}]}], "+", 
  RowBox[{"k1", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"d", " ", 
        SuperscriptBox["h", "\[Alpha]"]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], ")"}]}], "-", 
  FractionBox[
   SuperscriptBox["h", 
    RowBox[{"2", " ", "\[Alpha]"}]], 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]], " ", "\[Sigma]"}], 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]]}]], "Output",
 CellChangeTimes->{
  3.9739195793572063`*^9, 3.973919657218256*^9, {3.973919727464136*^9, 
   3.9739197358181496`*^9}, {3.974005396291645*^9, 3.974005401726015*^9}},
 CellLabel->"Out[34]=",ExpressionUUID->"a3f1389e-ee1e-cb4c-924e-62623a856ebe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["d", "2"], " ", 
      SuperscriptBox["h", "\[Alpha]"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
    FractionBox[
     RowBox[{"2", " ", "d", " ", 
      SuperscriptBox["h", "\[Alpha]"], " ", "r"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", 
      SuperscriptBox["r", "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"coefficient", " ", "of", " ", "k2", " ", "for", " ", "L2"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.97400542232267*^9, 3.974005432600067*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"f92e6898-9e49-0742-955f-a10a1b8a6a77"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["h", "\[Alpha]"], " ", 
   RowBox[{"(", 
    RowBox[{"d", "-", "r"}], ")"}]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "\[Alpha]"}], "]"}]]], "Output",
 CellChangeTimes->{3.9740054348660755`*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"f75804d0-d1d8-1446-895c-dd23a07ddff6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"d", " ", 
       SuperscriptBox["h", "\[Alpha]"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"coefficient", " ", "of", " ", "k1", " ", "for", " ", "L2"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.974005456106556*^9, 3.974005468241024*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"90979403-65fd-2343-8636-a0c4f9ab1a6c"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["h", "\[Alpha]"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "d"}], "+", 
     RowBox[{"r", " ", "\[Sigma]"}]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]], "Output",
 CellChangeTimes->{3.974005470072933*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"a3653aed-336e-b84e-bd8a-a82718b9d590"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]], 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]]}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]], " ", "\[Sigma]"}], 
     SuperscriptBox[
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"constant", " ", "term", " ", "for", " ", "L2"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.9740054875488987`*^9, 3.974005507378622*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"572711b0-fef9-494a-a6b1-aa44fd0b8b11"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["h", 
    RowBox[{"2", " ", "\[Alpha]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]]], "Output",
 CellChangeTimes->{3.9740055090275803`*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"34bb05ae-d936-f048-aa0c-a2ad0b200aff"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"Assume", " ", "\[Lambda]1"}], "=", 
    RowBox[{"-", "1"}]}], ",", " ", 
   RowBox[{
   "in", " ", "the", " ", "same", " ", "way", " ", "we", " ", "find", " ", 
    "L3"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.973919760502924*^9, 
  3.9739197717712536`*^9}},ExpressionUUID->"12c7460b-05b0-0c42-bd7b-\
a4169f153874"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c6", " ", "=", " ", 
  RowBox[{"lm3", "+", "1"}]}]], "Input",
 CellChangeTimes->{{3.973919796547079*^9, 3.9739198175413837`*^9}, {
  3.9739198480174065`*^9, 3.9739198481868668`*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"0470992b-ae49-0642-ab88-68e89555cd70"],

Cell[BoxData[
 RowBox[{"3", "-", "k1", "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "d"}], "+", 
      RowBox[{"r", " ", "\[Sigma]"}]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{{3.973919819487831*^9, 3.973919848533638*^9}, 
   3.974005536841177*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"557f23c0-6c7b-5342-bf6f-c710fd311ea9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c7", " ", "=", " ", 
  RowBox[{"lm4", "*", 
   RowBox[{"-", "1"}]}]}]], "Input",
 CellChangeTimes->{{3.97391986066378*^9, 3.973919864603636*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"5760145e-5ca8-6943-b6ae-e645f6c27900"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "k1", "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["h", "\[Alpha]"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["d", "2"], " ", "k2", " ", "r"}], "+", 
          RowBox[{"k2", " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "k1", "+", 
             RowBox[{"2", " ", "k2", " ", 
              SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "k1"}], ")"}], " ", "r", " ", 
           "\[Sigma]"}]}], ")"}], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]]}]], "Output",
 CellChangeTimes->{3.9739198662590504`*^9, 3.974005538813717*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"372907d4-e82f-c14c-acd5-cf1211a2915a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c8", " ", "=", " ", 
  RowBox[{"c6", "==", "c7"}]}]], "Input",
 CellChangeTimes->{{3.97391987669207*^9, 3.9739198824114475`*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"450a398e-5773-bb4a-8788-c958060b3f7f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", "-", "k1", "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "d"}], "+", 
       RowBox[{"r", " ", "\[Sigma]"}]}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "1"}], "+", "k1", "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["h", "\[Alpha]"]}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["d", "2"], " ", "k2", " ", "r"}], "+", 
           RowBox[{"k2", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"d", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "k1", "+", 
              RowBox[{"2", " ", "k2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "k1"}], ")"}], " ", "r", " ", 
            "\[Sigma]"}]}], ")"}], " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]]}]}]], "Output",
 CellChangeTimes->{3.9739198838099785`*^9, 3.9740055407758274`*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"02cb3163-b97b-e142-a78c-6c35f35c3be6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"c9", " ", "=", " ", 
   RowBox[{"c8", "/.", " ", 
    RowBox[{
     RowBox[{"Equal", "[", 
      RowBox[{"lhs_", ",", "rhs_"}], "]"}], ":>", 
     RowBox[{"Equal", "[", 
      RowBox[{
       RowBox[{"lhs", "-", "rhs"}], ",", "0"}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.973919900726448*^9, 3.9739199068877983`*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"9686225e-0fc9-6945-9d57-4f2eaea9fcc7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"expandedEqn2", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{"c9", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"collectedEqn2", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{"expandedEqn2", ",", 
    RowBox[{"{", 
     RowBox[{"k1", ",", "k2"}], "}"}]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"find", " ", "L3"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.973919922341593*^9, 3.973919950879797*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"2cf563d1-ddce-bb4d-9035-61388ab19f52"],

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{"k2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["d", "2"], " ", 
        SuperscriptBox["h", "\[Alpha]"]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "+", 
     FractionBox[
      RowBox[{"2", " ", "d", " ", 
       SuperscriptBox["h", "\[Alpha]"], " ", "r"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       SuperscriptBox["r", "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], ")"}]}], "+", 
  RowBox[{"k1", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     FractionBox[
      RowBox[{"d", " ", 
       SuperscriptBox["h", "\[Alpha]"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], ")"}]}], "+", 
  FractionBox[
   SuperscriptBox["h", 
    RowBox[{"2", " ", "\[Alpha]"}]], 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]], " ", "\[Sigma]"}], 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", "d", " ", 
    SuperscriptBox["h", "\[Alpha]"]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{3.97391993143808*^9, 3.9740055450248146`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"72a19d03-262f-564f-90dc-047f365ec343"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["d", "2"], " ", 
       SuperscriptBox["h", "\[Alpha]"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "+", 
    FractionBox[
     RowBox[{"2", " ", "d", " ", 
      SuperscriptBox["h", "\[Alpha]"], " ", "r"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", 
      SuperscriptBox["r", "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"coefficient", " ", "of", " ", "k2", " ", "for", " ", "L3"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.974005549733076*^9, 
  3.9740055919265327`*^9}},ExpressionUUID->"a1acdcd8-a31b-5c43-99f1-\
581e1b7f95d0"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["h", "\[Alpha]"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "d"}], "+", "r"}], ")"}]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "\[Alpha]"}], "]"}]]], "Output",
 CellChangeTimes->{3.9740055759919777`*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"97eb5c27-9d5c-2643-9595-d53d6d7c2855"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["d", "2"], " ", 
       SuperscriptBox["h", "\[Alpha]"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "+", 
    FractionBox[
     RowBox[{"2", " ", "d", " ", 
      SuperscriptBox["h", "\[Alpha]"], " ", "r"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", 
      SuperscriptBox["r", "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"coefficient", " ", "of", " ", "k1", " ", "for", " ", "L3"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.9740055897605667`*^9, 3.974005593263672*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"77cb6a56-e660-4d4d-8868-6f8e49a65543"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["h", "\[Alpha]"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "d"}], "+", "r"}], ")"}]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "\[Alpha]"}], "]"}]]], "Output",
 CellChangeTimes->{3.9740056055072384`*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"35bdcefc-c8fa-794e-b42f-4a160ac60712"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{"4", "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]], " ", "\[Sigma]"}], 
     SuperscriptBox[
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]], "-", 
    FractionBox[
     RowBox[{"2", " ", "d", " ", 
      SuperscriptBox["h", "\[Alpha]"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"constant", " ", "term", " ", "for", " ", "L3"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.9740056229884605`*^9, 3.9740056465267696`*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"3fdb0b46-5819-b649-a79c-0bdbca2fce42"],

Cell[BoxData[
 RowBox[{"4", "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "\[Sigma]"}], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"d", "-", 
          RowBox[{"r", " ", "\[Sigma]"}]}], ")"}], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]]}]], "Output",
 CellChangeTimes->{3.974005647658842*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"9da66437-420a-e540-a34b-91cd567ab78a"]
}, Open  ]]
},
WindowSize->{948, 520},
WindowMargins->{{0.5, Automatic}, {Automatic, 0.5}},
FrontEndVersion->"14.1 for Microsoft Windows (64-bit) (July 16, 2024)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"f9628cbb-ac80-1147-aa73-feefe93c934d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 2832, 78, 96, "Input",ExpressionUUID->"c7e555be-d259-6b4b-931f-4cc5b63ec8ae"],
Cell[3411, 102, 1790, 54, 89, "Output",ExpressionUUID->"5ea7f43e-e4e2-0947-9ada-0b59de806228"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5238, 161, 2163, 61, 72, "Input",ExpressionUUID->"d596aa5a-cd89-304e-962b-1a9a3e18f9c9"],
Cell[7404, 224, 1917, 58, 89, "Output",ExpressionUUID->"9a9dbecb-e054-f744-8b98-7d5aa39740a4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9358, 287, 1904, 55, 72, "Input",ExpressionUUID->"92a82ba8-e563-2245-bd3c-745cb4094336"],
Cell[11265, 344, 3901, 130, 133, "Output",ExpressionUUID->"9f97c47f-e95b-f044-9c14-6667bf0f2bf8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15203, 479, 4236, 132, 178, "Input",ExpressionUUID->"3e120c17-c08e-df42-bc97-448fed5ec861"],
Cell[19442, 613, 4072, 132, 136, "Output",ExpressionUUID->"95f24ab6-8f4b-c442-831a-062530d99ae0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23551, 750, 1043, 30, 46, "Input",ExpressionUUID->"6c05c2e6-8556-d24b-a83f-2f908586e7bd"],
Cell[24597, 782, 631, 17, 49, "Output",ExpressionUUID->"0a6da35c-a0bb-f245-9dba-d557f7134f70"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25265, 804, 3492, 107, 136, "Input",ExpressionUUID->"02fb311f-5420-3446-92ed-c91809b5b90c"],
Cell[28760, 913, 1505, 43, 65, "Output",ExpressionUUID->"47a9cf8c-c8d5-7949-8a88-100779dd8331"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30302, 961, 1620, 50, 72, "Input",ExpressionUUID->"0d4bcbf9-f0b8-e249-9db7-6f7088d0d734"],
Cell[31925, 1013, 1528, 46, 56, "Output",ExpressionUUID->"9a79bf59-581f-ab4d-9992-c7fd1db2ac36"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33490, 1064, 1444, 46, 55, "Input",ExpressionUUID->"f054aa81-0146-0246-b3a2-98aa553e25f0"],
Cell[34937, 1112, 10895, 267, 257, "Output",ExpressionUUID->"9eb79158-c5d7-254e-adeb-14a1a6454086"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45869, 1384, 5586, 136, 204, "Input",ExpressionUUID->"1c0c183a-6233-354f-b26f-0c74ed9192ca"],
Cell[51458, 1522, 3320, 91, 93, "Output",ExpressionUUID->"644bd247-9fbe-3648-819a-6e609e31bf08"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54815, 1618, 5551, 135, 204, "Input",ExpressionUUID->"1ef5c451-09c4-544b-80ab-f9d3f4b28c20"],
Cell[60369, 1755, 3191, 91, 93, "Output",ExpressionUUID->"7b8838a8-2f1f-d749-b4ed-a2501038082c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63597, 1851, 343, 7, 28, "Input",ExpressionUUID->"358ad470-bfb5-6e45-8823-41b42bfe82b0"],
Cell[63943, 1860, 602, 17, 49, "Output",ExpressionUUID->"f4bd2309-5988-3b40-beb0-2ba58f3289ef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64582, 1882, 394, 8, 28, "Input",ExpressionUUID->"6dc6f156-63e0-7741-8782-71a02c218079"],
Cell[64979, 1892, 1476, 42, 65, "Output",ExpressionUUID->"180d2816-6761-3b4f-bb18-7be79335f73e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66492, 1939, 357, 7, 28, "Input",ExpressionUUID->"807fe882-5906-da4c-b26b-e4a12898751b"],
Cell[66852, 1948, 1527, 44, 65, "Output",ExpressionUUID->"f4aa79bd-36d5-0049-917b-c74e17faf28f"]
}, Open  ]],
Cell[68394, 1995, 431, 11, 28, "Input",ExpressionUUID->"6f84f3c2-d9dd-4c43-a2ac-b7c34e9240bc"],
Cell[CellGroupData[{
Cell[68850, 2010, 482, 12, 47, "Input",ExpressionUUID->"b97819f6-6c6b-a548-ac8c-e5b9e3363b92"],
Cell[69335, 2024, 2595, 82, 96, "Output",ExpressionUUID->"b02a2cd5-72a9-d64e-8044-291f4a59b21b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71967, 2111, 1154, 36, 48, "Input",ExpressionUUID->"34f18b08-074b-0547-ae46-2e8b1d6f67b9"],
Cell[73124, 2149, 357, 10, 49, "Output",ExpressionUUID->"bd515262-33bd-4c4e-ac08-7ed6a34502ab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73518, 2164, 853, 24, 46, "Input",ExpressionUUID->"83f3eacc-ce47-1f40-9f12-6d7b79d5e339"],
Cell[74374, 2190, 512, 14, 49, "Output",ExpressionUUID->"31bdbe05-0eee-9747-8b55-18f70a481ad9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74923, 2209, 1244, 37, 49, "Input",ExpressionUUID->"91f1f026-bc72-2246-acaf-3242b50757c3"],
Cell[76170, 2248, 861, 27, 60, "Output",ExpressionUUID->"3544c471-f6d9-3c40-b9b0-ddae60e49b54"]
}, Open  ]],
Cell[77046, 2278, 442, 11, 28, "Input",ExpressionUUID->"4a7d0483-5ebe-314b-aaf2-e5b32d5083a5"],
Cell[CellGroupData[{
Cell[77513, 2293, 300, 5, 28, "Input",ExpressionUUID->"965652a7-2142-8e42-9ec7-89713432e5f2"],
Cell[77816, 2300, 568, 16, 49, "Output",ExpressionUUID->"b9dafd9e-eaba-484b-9bc2-f3653ad31b6b"]
}, Open  ]],
Cell[78399, 2319, 272, 5, 28, "Input",ExpressionUUID->"6af14581-f8ab-7149-9e36-8709e73d01d2"],
Cell[78674, 2326, 473, 9, 28, "Input",ExpressionUUID->"4465f9a9-0eb2-b541-911b-70fd9552ee9b"],
Cell[CellGroupData[{
Cell[79172, 2339, 334, 6, 28, "Input",ExpressionUUID->"571a9710-5594-fe4a-adf7-4beb043937f7"],
Cell[79509, 2347, 1886, 56, 65, "Output",ExpressionUUID->"4cc08497-1f62-a14b-945d-c4098b0ee225"]
}, Open  ]],
Cell[81410, 2406, 446, 11, 28, "Input",ExpressionUUID->"9ea03006-6989-4f49-902a-fa5068a0fe17"],
Cell[CellGroupData[{
Cell[81881, 2421, 596, 15, 47, "Input",ExpressionUUID->"d0f78764-4bc3-434d-8aa8-f0de0d4457e4"],
Cell[82480, 2438, 2189, 67, 96, "Output",ExpressionUUID->"a3f1389e-ee1e-cb4c-924e-62623a856ebe"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84706, 2510, 1143, 34, 48, "Input",ExpressionUUID->"f92e6898-9e49-0742-955f-a10a1b8a6a77"],
Cell[85852, 2546, 338, 9, 49, "Output",ExpressionUUID->"f75804d0-d1d8-1446-895c-dd23a07ddff6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86227, 2560, 867, 25, 46, "Input",ExpressionUUID->"90979403-65fd-2343-8636-a0c4f9ab1a6c"],
Cell[87097, 2587, 474, 14, 49, "Output",ExpressionUUID->"a3653aed-336e-b84e-bd8a-a82718b9d590"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87608, 2606, 765, 22, 49, "Input",ExpressionUUID->"572711b0-fef9-494a-a6b1-aa44fd0b8b11"],
Cell[88376, 2630, 417, 12, 51, "Output",ExpressionUUID->"34bb05ae-d936-f048-aa0c-a2ad0b200aff"]
}, Open  ]],
Cell[88808, 2645, 391, 11, 28, "Input",ExpressionUUID->"12c7460b-05b0-0c42-bd7b-a4169f153874"],
Cell[CellGroupData[{
Cell[89224, 2660, 285, 5, 28, "Input",ExpressionUUID->"0470992b-ae49-0642-ab88-68e89555cd70"],
Cell[89512, 2667, 569, 16, 49, "Output",ExpressionUUID->"557f23c0-6c7b-5342-bf6f-c710fd311ea9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90118, 2688, 248, 5, 28, "Input",ExpressionUUID->"5760145e-5ca8-6943-b6ae-e645f6c27900"],
Cell[90369, 2695, 1427, 42, 65, "Output",ExpressionUUID->"372907d4-e82f-c14c-acd5-cf1211a2915a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91833, 2742, 232, 4, 28, "Input",ExpressionUUID->"450a398e-5773-bb4a-8788-c958060b3f7f"],
Cell[92068, 2748, 1881, 56, 65, "Output",ExpressionUUID->"02cb3163-b97b-e142-a78c-6c35f35c3be6"]
}, Open  ]],
Cell[93964, 2807, 444, 11, 28, "Input",ExpressionUUID->"9686225e-0fc9-6945-9d57-4f2eaea9fcc7"],
Cell[CellGroupData[{
Cell[94433, 2822, 541, 14, 47, "Input",ExpressionUUID->"2cf563d1-ddce-bb4d-9035-61388ab19f52"],
Cell[94977, 2838, 2626, 82, 139, "Output",ExpressionUUID->"72a19d03-262f-564f-90dc-047f365ec343"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97640, 2925, 1156, 36, 48, "Input",ExpressionUUID->"a1acdcd8-a31b-5c43-99f1-581e1b7f95d0"],
Cell[98799, 2963, 359, 10, 49, "Output",ExpressionUUID->"97eb5c27-9d5c-2643-9595-d53d6d7c2855"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99195, 2978, 1175, 35, 48, "Input",ExpressionUUID->"77cb6a56-e660-4d4d-8868-6f8e49a65543"],
Cell[100373, 3015, 359, 10, 49, "Output",ExpressionUUID->"35bdcefc-c8fa-794e-b42f-4a160ac60712"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100769, 3030, 1088, 31, 49, "Input",ExpressionUUID->"3fdb0b46-5819-b649-a79c-0bdbca2fce42"],
Cell[101860, 3063, 784, 23, 79, "Output",ExpressionUUID->"9da66437-420a-e540-a34b-91cd567ab78a"]
}, Open  ]]
}
]
*)

